{*******************************************************}
{                                                       }
{       RichView                                        }
{       RVF File Viewer for Directory Opus              }
{                                                       }
{       TRichView (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{       Directory Opus (c) GP Software                  }
{       http://www.gpsoft.com.au                        }
{                                                       }
{*******************************************************}

library RVView;

uses
  SysUtils,
  Windows, Graphics,
  Classes, Forms, Controls, StdCtrls,
  Messages, ShellApi,
  DirectoryOpusViewerPlugins in 'DirectoryOpusViewerPlugins.pas',
  PngImage, RVGifAnimate2007,
  RichView, CRVFData,
  RVScroll, PtblRV, Dialogs, RVReport,
  RVStyle;

{$R *.res}

type
  TOpusRichView = class (TRichView)
  private
    FInitializing, FLink: Boolean;
    FFileName: String;
    procedure DVPLUGINMSGLoad(var Msg: TMessage); message DVPLUGINMSG_LOADW;
    procedure DVPLUGINMSGGetInfo(var Msg: TMessage); message DVPLUGINMSG_GETIMAGEINFOW;
    procedure DVPLUGINMSGGetCaps(var Msg: TMessage); message DVPLUGINMSG_GETCAPABILITIES;
    procedure DVPLUGINMSGResize(var Msg: TMessage); message DVPLUGINMSG_RESIZE;
    procedure DVPLUGINMSGZoom(var Msg: TMessage); message DVPLUGINMSG_ZOOM;
    procedure DVPLUGINMSGSelectAll(var Msg: TMessage); message DVPLUGINMSG_SELECTALL;
    procedure DVPLUGINMSGTestSelection(var Msg: TMessage); message DVPLUGINMSG_TESTSELECTION;
    procedure DVPLUGINMSGCopySelection(var Msg: TMessage); message DVPLUGINMSG_COPYSELECTION;
    procedure DVPLUGINMSGClear(var Msg: TMessage); message DVPLUGINMSG_CLEAR;
    procedure DVPLUGINMSGPrint(var Msg: TMessage); message DVPLUGINMSG_PRINT;
    procedure DVPLUGINMSGShowHideScrollbars(var Msg: TMessage); message DVPLUGINMSG_SHOWHIDESCROLLBARS;
    procedure DVPLUGINMSGMouseWheel(var Msg: TMessage); message DVPLUGINMSG_MOUSEWHEEL;
    procedure WMNCDestroy(var Msg: TWMNCDestroy); message WM_NCDESTROY;
    procedure WMMouseWheel(var Msg: TMessage); message WM_MOUSEWHEEL;
  protected
    procedure WndProc(var Message: TMessage); override;
  public
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
  end;


const PluginGUID: TGUID = '{914D8EE6-2C0A-11DD-BF72-BEBE56D89593}';
{------------------------------------------------------------------------------}
// Fake object for event processing
type
  TFakeObject = class
    procedure DoJump(Sender: TObject; id: Integer);
  end;

procedure TFakeObject.DoJump(Sender: TObject; id: Integer);
var RVData: TCustomRVFormattedData;
    ItemNo: Integer;
begin
  TOpusRichView(Sender).FLink := True;
  TRichView(Sender).GetJumpPointLocation(id, RVData, ItemNo);
  ShellExecute(0, 'open', PChar(RVData.GetItemTag(ItemNo)), nil, nil, SW_SHOW);
end;

var obj: TFakeObject = nil;
{------------------------------------------------------------------------------}

function DVP_IdentifyW(var InitInfo: TDOpusViewerPluginInfoW): Boolean; cdecl;
begin
  try
    InitInfo.dwFlags := DVPFIF_ExtensionsOnly or DVPFIF_NoMultithreadThumbnails;

    InitInfo.dwVersionHigh := $10000;
    InitInfo.dwVersionLow := 1;

    if InitInfo.lpszHandleExts<>nil then
      StrLCopy(InitInfo.lpszHandleExts, '.rvf', InitInfo.cchHandleExtsMax - 1);

    if InitInfo.lpszName<>nil then
      StrLCopy(InitInfo.lpszName, 'RVF File', InitInfo.cchNameMax - 1);

    if InitInfo.lpszDescription<>nil then
      StrLCopy(InitInfo.lpszDescription, 'Viewer for RichView format files', InitInfo.cchDescriptionMax - 1);

    if InitInfo.lpszCopyright<>nil then
      StrLCopy(InitInfo.lpszCopyright, '(c) Sergey Tkachenko', InitInfo.cchCopyrightMax - 1);

    if InitInfo.lpszURL<>nil then
      StrLCopy(InitInfo.lpszURL, 'http://www.trichview.com', InitInfo.cchURLMax - 1);

    InitInfo.dwlMinFileSize := 8;
    InitInfo.dwlMaxFileSize := 0;
    InitInfo.dwlMinPreviewFileSize := 8;
    InitInfo.dwlMaxPreviewFileSize := 0;
    InitInfo.uiMajorFileType := DVPMajorType_Text;
    InitInfo.idPlugin := PluginGUID;
    Result := True;
  except
    Result := False;
  end;
end;
{------------------------------------------------------------------------------}
function DVP_IdentifyFileW(hWnd: HWND; lpszName: LPTSTR;
  var lpVPFileInfo: TLPVIEWERPLUGINFILEINFOW; hAbortEvent: THANDLE): Boolean; cdecl;
begin
  try
    lpVPFileInfo.dwFlags := DVPFIF_CanReturnViewer or DVPFIF_CanReturnThumbnail;
    lpVPFileInfo.wMajorType := ord(DVPMajorType_Text);
    lpVPFileInfo.wMinorType := 0;
    lpVPFileInfo.szImageSize.cx := 0;
    lpVPFileInfo.szImageSize.cy := 0;
    lpVPFileInfo.iNumBits := 0;
    if lpVPFileInfo.lpszInfo<>nil then
      StrLCopy(lpVPFileInfo.lpszInfo, PChar('RVF File'), lpVPFileInfo.cchInfoMax - 1);
    Result := True;
  except
    Result := False;
  end;
end;
{------------------------------------------------------------------------------}
function DVP_CreateViewer(hWndParent: HWND; var lpRc: TRECT; dwFlags: DWORD): HWND; cdecl;
var rv: TOpusRichView;
begin
  rv := TOpusRichView.Create(nil);
  rv.FInitializing := True;
  try
    rv.ParentWindow := hWndParent;
    rv.Style := TRVStyle.Create(rv);
    rv.AnimationMode := rvaniOnFormat;
    if (dwFlags and DVPCVF_Border)=0 then
      rv.BorderStyle := bsNone;
    rv.Options := rv.Options + [rvoClientTextWidth];
    rv.RTFReadProperties.TextStyleMode := rvrsAddIfNeeded;
    rv.RTFReadProperties.ParaStyleMode := rvrsAddIfNeeded;
    rv.RVFTextStylesReadMode := rvf_sInsertMerge;
    rv.RVFParaStylesReadMode := rvf_sInsertMerge;
    rv.RVFOptions := rv.RVFOptions + [rvfoIgnoreUnknownPicFmt,
      rvfoIgnoreUnknownCtrls, rvfoConvUnknownStylesToZero,
      rvfoConvLargeImageIdxToZero, rvfoLoadBack, rvfoLoadLayout];
    rv.OnJump := obj.DoJump;
    with lpRc do
      rv.SetBounds(Left, Top, Right, Bottom);
    rv.Format;
    Result := rv.Handle;
  finally
    rv.FInitializing := False;
  end;
end;

function MakeBitmap(const FileName: String; Width, Height: Integer): HBITMAP;
var rvh: TRVReportHelper;
    Stream: TFileStream;
    bmp : TBitmap;
begin
  bmp := nil;
  try
    bmp := TBitmap.Create;
    bmp.Width := Width;
    bmp.Height := Height;
    rvh := TRVReportHelper.Create(nil);
    try
      rvh.RichView.Style := TRVStyle.Create(rvh);
      rvh.RichView.Options := rvh.RichView.Options+[rvoTagsArePChars];
      rvh.RichView.RVFTextStylesReadMode := rvf_sInsertMerge;
      rvh.RichView.RVFParaStylesReadMode := rvf_sInsertMerge;
      rvh.RichView.RVFOptions := rvh.RichView.RVFOptions + [rvfoIgnoreUnknownPicFmt,
        rvfoIgnoreUnknownCtrls, rvfoConvUnknownStylesToZero,
        rvfoConvLargeImageIdxToZero, rvfoLoadBack, rvfoLoadLayout];
      Stream := TFileStream.Create(FileName, fmOpenRead);
      try
        rvh.RichView.LoadRVFFromStream(Stream)
      finally
        Stream.Free;
      end;
      rvh.Init(bmp.Canvas, Width);
      rvh.FormatNextPage(Height);
      if rvh.Finished and (rvh.GetLastPageHeight<Height) then begin
        Height := rvh.GetLastPageHeight;
        bmp.Height := Height;
      end;
      rvh.DrawPage(1, bmp.Canvas, True, Height);
    finally
      rvh.Free;
    end;
    Result := bmp.ReleaseHandle;
    bmp.Free;
  except
    bmp.Free;
    Result := 0;
  end;
end;

function DVP_LoadBitmapW(hWnd: HWND; lpszName: LPTSTR;
  lpVPFileInfo: TLPVIEWERPLUGINFILEINFOW; lpszDesiredSize: TtagSIZE;
  hAbortEvent: THANDLE): HBITMAP; cdecl;
begin
  Result := MakeBitmap(lpszName, 500, 500);
end;

exports DVP_IdentifyW       name DVPFUNCNAME_IDENTIFYW;
exports DVP_CreateViewer    name DVPFUNCNAME_CREATEVIEWER;
exports DVP_LoadBitmapW    name DVPFUNCNAME_LOADBITMAPW;
exports DVP_IdentifyFileW   name DVPFUNCNAME_IDENTIFYFILEW;



{============================ TOpusRichView ===================================}

procedure TOpusRichView.DVPLUGINMSGLoad(var Msg: TMessage);
begin
  FFileName := PChar(Msg.LParam);
  Clear;
  Msg.Result := ord(LoadRVF(FFileName));
  Format;
end;

procedure TOpusRichView.DVPLUGINMSGGetInfo(var Msg: TMessage);
begin
  inherited;
end;

procedure TOpusRichView.DVPLUGINMSGGetCaps(var Msg: TMessage);

begin
  Msg.Result :=
        VPCAPABILITY_SELECTALL
        or VPCAPABILITY_COPYALL
        or VPCAPABILITY_COPYSELECTION
        or VPCAPABILITY_WANTFOCUS
        or VPCAPABILITY_SHOWPROPERTIES
        or VPCAPABILITY_WANTMOUSEWHEEL
        or VPCAPABILITY_PRINT;
end;

procedure TOpusRichView.DVPLUGINMSGResize(var Msg: TMessage);
begin
  SetBounds(Msg.WParamLo, Msg.WParamHi, Msg.LParamLo, Msg.LParamHi);
end;

procedure TOpusRichView.DVPLUGINMSGZoom(var Msg: TMessage);
begin
  inherited;
end;

procedure TOpusRichView.DVPLUGINMSGSelectAll(var Msg: TMessage);
begin
  SelectAll;
  Invalidate;
  Msg.Result := 1;
end;

procedure TOpusRichView.DVPLUGINMSGTestSelection(var Msg: TMessage);
begin
  Msg.Result := ord(SelectionExists);
end;

procedure TOpusRichView.DVPLUGINMSGCopySelection(var Msg: TMessage);
begin
  CopyDef;
end;

procedure TOpusRichView.DVPLUGINMSGClear(var Msg: TMessage);
begin
  Clear;
  Format;
end;

procedure TOpusRichView.DVPLUGINMSGMouseWheel(var Msg: TMessage);
begin
  Perform(CM_MOUSEWHEEL, Msg.WParam, Msg.LParam);
  inherited;
end;

procedure TOpusRichView.DVPLUGINMSGShowHideScrollbars(var Msg: TMessage);
begin
  VScrollVisible := Msg.WParam<>0;
  HScrollVisible := Msg.WParam<>0;  
end;

procedure TOpusRichView.DVPLUGINMSGPrint(var Msg: TMessage);
var rvp: TRVPrint;
    pd: TPrintDialog;
begin
  if (ItemCount=0) then
    exit;
  rvp := TRVPrint.Create(Self);
  try
    rvp.AssignDocParameters(DocParameters);
    rvp.AssignSource(Self);
    rvp.FormatPages(rvdoALL);
    pd := TPrintDialog.Create(nil);
    try
      pd.Options := [poPageNums];
      pd.MinPage := 1;
      pd.MaxPage := rvp.PagesCount;
      pd.FromPage := 1;
      pd.ToPage := rvp.PagesCount;
      if pd.Execute then
        case pd.PrintRange of
          prAllPages:
            rvp.Print(ExtractFileName(FFileName), pd.Copies, False);
          prPageNums:
            rvp.PrintPages(pd.FromPage, pd.ToPage, ExtractFileName(FFileName),
              pd.Copies, False);
        end;
    finally
      pd.Free;
    end;
  finally
    rvp.Free;
  end;
end;

procedure TOpusRichView.WMNCDestroy(var Msg: TWMNCDestroy);
begin
  inherited;
  if not FInitializing then
    Free;
end;

procedure TOpusRichView.WndProc(var Message: TMessage);
begin
  inherited;
end;

procedure TOpusRichView.WMMouseWheel(var Msg: TMessage);
var NotifyMsg: TtagDVPNMMOUSEWHEEL;
begin
  NotifyMsg.hdr.hwndFrom := Handle;
  NotifyMsg.hdr.idFrom := Handle;
  NotifyMsg.hdr.code := DVPN_MOUSEWHEEL;
  NotifyMsg.wParam := Msg.WParam;
  NotifyMsg.lParam := Msg.LParam;
  Msg.Result := SendMessage(ParentWindow, WM_NOTIFY, Handle, LPARAM(@NotifyMsg));
//  inherited;
end;

procedure TOpusRichView.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
var NotifyMsg: TtagDVPNMCLICK;
begin
  FLink := False;
  inherited;
  if FLink then
    exit;
  case Button of
    mbLeft:   NotifyMsg.hdr.code := DVPN_CLICK;
    mbMiddle: NotifyMsg.hdr.code := DVPN_MCLICK;
    else exit;
  end;
  NotifyMsg.hdr.hwndFrom := Handle;
  NotifyMsg.hdr.idFrom := 0;
  NotifyMsg.hdr.code := DVPN_CLICK;
  NotifyMsg.pt := Point(X, Y);
  NotifyMsg.fMenu := (Y<10) or (Y>ClientHeight-10);
  SendMessage(ParentWindow, WM_NOTIFY, Handle, LPARAM(@NotifyMsg));
end;

begin
  RegisterClasses([TButton, TCheckBox, TRadioButton, TEdit, TMemo, TComboBox]);
end.
